package de.renew.engine.searcher;


/**
 * Something that can be triggered in the triggering algorithm
 * by {@link #proposeSearch()}.
 * Currently implemented by {@literal @link TransitionInstance} and
 * {@literal @link SynchronisationRequest} within {@link de.renew}.
 * <p>
 * Also see the description of {@link TriggerableCollection}.
 */
public interface Triggerable {

    /**
     * Return the set of all triggers.
     *
     * @return the set of all triggers
     */
    TriggerCollection triggers();

    /**
     * Trigger a new search because bindings might have appeared of
     * disappeared.
     */
    void proposeSearch();
}