package de.renew.engine.searchqueue;

import java.util.Enumeration;
import java.util.NoSuchElementException;

import de.renew.engine.searcher.Searchable;

/**
 * An enumeration for the elements of a deterministic search queue.
 */
class DSQEnumeration implements Enumeration<Searchable> {
    private DSQListNode _current;
    private final DSQListNode _start;

    DSQEnumeration(DSQListNode start) {
        _current = start;
        _start = start;
    }

    @Override
    public boolean hasMoreElements() {
        return _current != null;
    }

    @Override
    public synchronized Searchable nextElement() throws NoSuchElementException {
        if (_current == null) {
            throw new NoSuchElementException();
        }
        Searchable result = _current.getElement();
        _current = _current.getNext();
        if (_current == _start) {
            _current = null;
        }
        return result;
    }
}