package de.renew.engine.searchqueue;

import de.renew.engine.thread.SimulationThreadPool;

/**
 * A factory for random search queues.
 */
public class RandomQueueFactory implements SearchQueueFactory {

    /**
     * Creates a new RandomQueueFactory.
     * The factory can only be used in a simulation thread.
     */
    public RandomQueueFactory() {}

    @Override
    public SearchQueueData makeQueue(double time) {
        assert SimulationThreadPool.isSimulationThread() : "is not in a simulation thread";
        return new RandomSearchQueue(time);
    }
}