package de.renew.engine.searchqueue;

import java.util.Enumeration;

import de.renew.engine.searcher.Searchable;

/**
 * A SearchQueueData object is used by the {@link SearchQueue} to store
 * Searchable objects that are scheduled for searching at a certain time.
 * The SearchQueueData interface provides methods to include and exclude
 * Searchable objects, extract the next Searchable to be processed,
 * enumerate all contained Searchable objects, and get the size of the queue.
 */
public interface SearchQueueData {
    /**
     * Get the time associated with this SearchQueueData.
     *
     * @return the time associated with this SearchQueueData
     */
    double getTime();

    /**
     * Include a Searchable object in the queue.
     *
     * @param searchable the Searchable object to include
     */
    void include(Searchable searchable);

    /**
     * Exclude a Searchable object from the queue.
     *
     * @param searchable the Searchable object to exclude
     */
    void exclude(Searchable searchable);

    /**
     * Extract and remove the next Searchable object from the queue.
     *
     * @return the next Searchable object to be processed
     */
    Searchable extract();

    /**
     * Get an enumeration of all Searchable objects in the queue.
     *
     * @return an enumeration of all Searchable objects in the queue
     */
    Enumeration<Searchable> elements();

    /**
     * Get the number of Searchable objects in the queue.
     *
     * @return the number of Searchable objects in the queue
     */
    int size();
}