package de.renew.engine.simulator;

import de.renew.engine.searcher.Finder;
import de.renew.engine.searcher.Searcher;
import de.renew.engine.thread.SimulationThreadPool;

/**
 * A {@link Finder} that can be aborted.
 */
public class AbortFinder implements Finder {
    private boolean _abortRequested = false;
    private final Finder _finder;

    /**
     * Creates an {@link AbortFinder} for a given {@link Finder}.
     *
     * @param finder the given {@link Finder}, which gets aborted
     */
    public AbortFinder(Finder finder) {
        assert SimulationThreadPool.isSimulationThread() : "is not in a simulation thread";
        _finder = finder;
    }

    @Override
    public void found(Searcher searcher) {
        assert SimulationThreadPool.isSimulationThread() : "is not in a simulation thread";
        _finder.found(searcher);
    }

    /**
     * Sets the abortion request for the search to true,
     * if the {@link SimulationThreadPool} is a SimulationThread.
     */
    public void abortSearch() {
        assert SimulationThreadPool.isSimulationThread() : "is not in a simulation thread";
        _abortRequested = true;
    }

    @Override
    public boolean isCompleted() {
        return _abortRequested || _finder.isCompleted();
    }
}