package de.renew.engine.simulator;

import java.util.ArrayList;
import java.util.Collection;

import de.renew.engine.searcher.Finder;
import de.renew.engine.searcher.Searcher;
import de.renew.engine.thread.SimulationThreadPool;


/**
 * A collecting finder lists all bindings that
 * are found by a searcher.
 */
class CollectingFinder implements Finder {
    private final Collection<Binding> _bindings = new ArrayList<>();

    @Override
    public void found(Searcher searcher) {
        assert SimulationThreadPool.isSimulationThread() : "is not in a simulation thread";
        _bindings.add(new Binding(searcher));
    }

    // I will never be satisfied with the bindings that I have collected.
    @Override
    public boolean isCompleted() {
        return false;
    }

    public Collection<Binding> bindings() {
        return _bindings;
    }
}