package de.renew.engine.simulator;

import de.renew.simulatorontology.simulation.Simulator;

/**
 * A ConcurrentChildSimulator is a child simulator that runs its
 * own thread to process events concurrently to its parent simulator.
 */
public class ConcurrentChildSimulator extends AbstractConcurrentChildSimulator {

    /**
     * Initializes a new ConcurrentChildSimulator with the option to choose
     * if event queue delay should be enabled.
     *
     * @param wantEventQueueDelay whether the simulator will wait for the event queue before every firing
     * @param parentSimulator the parent {@link Simulator}
     */
    public ConcurrentChildSimulator(boolean wantEventQueueDelay, Simulator parentSimulator) {
        super(wantEventQueueDelay, true, parentSimulator);
    }

    /**
     * Initializes a new ConcurrentChildSimulator with event queue delay enabled.
     *
     * @param parentSimulator the parent {@link Simulator}
     */
    public ConcurrentChildSimulator(Simulator parentSimulator) {
        super(true, true, parentSimulator);
    }
}