package de.renew.engine.simulator;

import de.renew.engine.searcher.Finder;
import de.renew.engine.searcher.Searcher;
import de.renew.engine.thread.SimulationThreadPool;

/**
 * A finder that checks whether a transition is enabled.
 * It stops the search as soon as a binding is found.
 */
class EnablednessFinder implements Finder {
    private boolean _bindingFound = false;

    @Override
    public void found(Searcher searcher) {
        assert SimulationThreadPool.isSimulationThread() : "is not in a simulation thread";
        _bindingFound = true;
    }

    // Return true if no other bindings should be tried.
    // After returning true once, the method must return true forever.
    @Override
    public boolean isCompleted() {
        return _bindingFound;
    }

    /**
     * Return whether a binding was found so far.
     * This might behave different from {@link #isCompleted()},
     * if we decide to make the search interruptable.
     *
     * @return true if a binding was found, false otherwise
     */
    public boolean isEnabled() {
        return _bindingFound;
    }
}