package de.renew.engine.simulator;

/**
 * A simulator that does not support concurrent execution of events.
 * This is the default simulator type.
 */
public class NonConcurrentSimulator extends AbstractConcurrentSimulator {
    /**
     * Creates a new {@link NonConcurrentSimulator}.
     *
     * @param wantEventQueueDelay whether the simulator will wait for the event queue before every firing
     */
    public NonConcurrentSimulator(boolean wantEventQueueDelay) {
        super(wantEventQueueDelay, false);
    }

    /**
     * Creates a new {@link NonConcurrentSimulator} that does not wait for the event queue before every firing.
     */
    public NonConcurrentSimulator() {
        super(true, false);
    }
}