package de.renew.expression;

import java.io.Serializable;

import de.renew.unify.Impossible;


/**
 * A {@code Function} is a function that takes an {@code Object} as an argument.
 */
public interface Function extends Serializable {
    /**
     * Returns the value the function evaluates to with a given input.
     *
     * @param arg the argument to be supplied to the function
     * @throws Impossible if evaluation is impossible
     * @return the value the function evaluates to
     */
    public Object function(Object arg) throws Impossible;
}