package de.renew.net;

import de.renew.engine.searcher.LateExecutable;
import de.renew.engine.thread.SimulationThreadPool;
import de.renew.net.event.FiringEvent;
import de.renew.simulatorontology.simulation.StepIdentifier;


/**
 * A {@code FiringStartExecutable} is an executable object that informs the {@link TransitionInstance}
 * of a {@link FiringEvent} that it has started firing.
 */
public class FiringStartExecutable implements LateExecutable {
    private final FiringEvent _event;

    FiringStartExecutable(FiringEvent event) {
        _event = event;
    }

    @Override
    public int phase() {
        return START;
    }

    @Override
    public boolean isLong() {
        return false;
    }

    @Override
    public void execute(StepIdentifier stepIdentifier) {
        assert SimulationThreadPool.isSimulationThread() : "is not in a simulation thread";
        _event.getTransitionInstance().firingStarted(_event);
    }

    @Override
    public void executeAfterException(StepIdentifier stepIdentifier, Throwable t) {
        assert SimulationThreadPool.isSimulationThread() : "is not in a simulation thread";
        // This should not happen, but ignore the exception.
        execute(stepIdentifier);
    }
}