package de.renew.net;

import java.io.Serializable;

import de.renew.expression.VariableMapper;
import de.renew.unify.Impossible;


/**
 * A TokenSource creates a new token whenever its {@link #createToken} method is called.
 */
public interface TokenSource extends Serializable {
    /**
     * Creates a new token.
     *
     * @param mapper a VariableMapper used by the {@link ExpressionTokenSource} to evaluate its expression
     * @return a new token
     * @throws Impossible if no token could be created
     */
    Object createToken(VariableMapper mapper) throws Impossible;
}