package de.renew.net;

import de.renew.engine.searcher.OccurrenceDescription;
import de.renew.expression.VariableMapper;


/**
 * The description of a transition occurrence.
 */
class TransitionOccurrenceDescription implements OccurrenceDescription {
    private final TransitionInstance _transitionInstance;
    private final VariableMapper _variableMapper;

    TransitionOccurrenceDescription(
        TransitionInstance transitionInstance, VariableMapper variableMapper)
    {
        _transitionInstance = transitionInstance;
        _variableMapper = variableMapper;
    }

    /**
     * Describe the transition occurrence by the means of transition
     * instance name and variables.
     */
    @Override
    public String getDescription() {
        StringBuffer descr = new StringBuffer();
        descr.append(_transitionInstance.toString());
        _variableMapper.appendBindingsTo(descr);
        return descr.toString();
    }
}