package de.renew.net.event;

import java.io.Serializable;

import de.renew.engine.thread.SimulationThreadPool;

/** This is a class for general net events. We do not use or inherit
 *  from java.util.EventObject, since it contains a memory leak bug
 *  in JDK 1.1.
 */
public abstract class NetEvent implements Serializable {
    /** The event source object. */
    protected final Object _source;

    /**
     * Constructs a new NetEvent with the given event source.
     *
     * @param source the source of the net event
     */
    protected NetEvent(Object source) {
        assert SimulationThreadPool.isSimulationThread() : "is not in a simulation thread";
        _source = source;
    }

    /**
     * Returns the event source object.
     *
     * @return the source object of the net event
     */
    public Object getSource() {
        return _source;
    }
}