package de.renew.net.event;

import java.util.EventListener;

/**
 * A general interface for listeners related to net events
 */
public interface NetEventListener extends EventListener {

    /**
     * Announce whether notifications should be done
     * synchronously or asynchronously. Synchronous access
     * might cause deadlocks due to subsequent synchronization,
     * Asynchronous access might cause notifications to arrive
     * too late.
     *
     * @return {@code true}, if notifications should be done
     *         synchronously.
     */
    boolean wantSynchronousNotification();
}