package de.renew.net.event;

import de.renew.net.PlaceInstance;

/**
 * A general class for Place-related net events.
 */
public class PlaceEvent extends NetEvent {

    /**
     * Constructs a PlaceEvent using the given {@link PlaceInstance} as the event source.
     *
     * @param instance the {@link PlaceInstance} as the event source
     */
    public PlaceEvent(PlaceInstance instance) {
        super(instance);
    }

    /**
     * Returns the event source as a {@link PlaceInstance}.
     *
     * @return the event source as a {@link PlaceInstance}
     */
    public PlaceInstance getPlaceInstance() {
        return (PlaceInstance) _source;
    }
}