package de.renew.net.inscription;

import java.io.Serializable;
import java.util.Collection;

import de.renew.engine.searcher.Occurrence;
import de.renew.engine.searcher.Searcher;
import de.renew.expression.VariableMapper;
import de.renew.net.NetInstance;
import de.renew.net.inscription.transition.ExpressionInscription;
import de.renew.unify.Impossible;

/**
 * This interface tags objects that may be inscribed to a transition.
 *
 * @author Olaf Kummer
 **/
public interface TransitionInscription extends Serializable {
    /**
     * Returns the {@code Occurrence}s that this inscription adds to a {@code Transition}.
     *
     * @param mapper the mapper used to create the {@code Occurrence}s
     * @param netInstance the {@code NetInstance} the transition resides in
     * @param searcher the {@code Searcher} that can be used to create the {@code Occurence}s
     *                 (for example by {@link ExpressionInscription}).
     * @throws Impossible if it is impossible to make the {@code Occurrence}s
     * @return the Occurrences that this inscription adds to a Transition
     */
    Collection<Occurrence> makeOccurrences(
        VariableMapper mapper, NetInstance netInstance, Searcher searcher) throws Impossible;
}