package de.renew.net.inscription.transition;

import java.util.Collection;
import java.util.List;
import java.util.Vector;

import de.renew.engine.searcher.Occurrence;
import de.renew.engine.searcher.Searcher;
import de.renew.expression.Expression;
import de.renew.expression.VariableMapper;
import de.renew.net.NetInstance;
import de.renew.net.Transition;
import de.renew.net.inscription.TransitionInscription;

/**
 * Usage of this class is unclear, apparently it is no longer in use.
 */
public class ConditionalInscription implements TransitionInscription {
    /**
     * The conditionExpression.
     */
    private final Expression _conditionExpression;

    /**
     * The TransitionInscription.
     */
    private final TransitionInscription _inscription;

    /**
     * The Transition that contains the ConditionalInscription.
     */
    private final Transition _transition;

    /**
     * Constructs a new ConditionalInscription with the given parameters.
     * Usage of this class is unclear, apparently it is no longer in use.
     *
     * @param conditionExpression the {@code Expression}
     * @param inscription the TransitionInscription
     * @param transition the Transition that contains the ConditionalInscription
     */
    public ConditionalInscription(
        Expression conditionExpression, TransitionInscription inscription, Transition transition)
    {
        _conditionExpression = conditionExpression;
        _inscription = inscription;
        _transition = transition;
    }

    /**
     * Returns the expression of this ConditionalInscription.
     *
     * @return the {@code Expression}
     */
    public Expression getExpression() {
        return _conditionExpression;
    }

    @Override
    public Collection<Occurrence> makeOccurrences(
        VariableMapper mapper, NetInstance netInstance, Searcher searcher)
    {
        return new Vector<>(
            List.of(new ConditionalOccurrence(this, mapper, netInstance, _transition)));
    }

    /**
     * Getter for {@code conditionExpression}.
     *
     * @return the {@code conditionExpression}
     */
    Expression getConditionExpression() {
        return _conditionExpression;
    }

    /**
     * Getter for {@code inscription}.
     *
     * @return the {@code inscription}
     */
    TransitionInscription getInscription() {
        return _inscription;
    }
}