package de.renew.net.inscription.transition;

import de.renew.engine.searcher.EarlyExecutable;
import de.renew.net.NetInstance;
import de.renew.simulatorontology.simulation.StepIdentifier;


class EarlyConfirmer implements EarlyExecutable {
    private final NetInstance _netInstance;

    EarlyConfirmer(NetInstance netInstance) {
        _netInstance = netInstance;
    }

    @Override
    public long lockPriority() {
        return 0;
    }

    @Override
    public void lock() {
        // Nothing to do.
    }

    @Override
    public int phase() {
        return EARLY_CONFIRM;
    }

    // This will not take long.
    public boolean isLong() {
        return false;
    }

    @Override
    public void verify(StepIdentifier stepIdentifier) {
        _netInstance.earlyConfirmation();
    }

    @Override
    public void execute(StepIdentifier stepIdentifier) {
        _netInstance.earlyConfirmationTrace(stepIdentifier);
    }

    @Override
    public void rollback() {
        // Nothing to do.
    }

    @Override
    public void unlock() {
        // Nothing to do.
    }
}