package de.renew.net.inscription.transition;

import de.renew.engine.searcher.LateExecutable;
import de.renew.net.NetInstance;
import de.renew.simulatorontology.simulation.StepIdentifier;


class LateConfirmer implements LateExecutable {
    private final NetInstance _netInstance;

    LateConfirmer(NetInstance netInstance) {
        _netInstance = netInstance;
    }

    @Override
    public int phase() {
        // This is a tricky question. When should we confirm
        // the creation of a net instance? If we confirm during
        // phase 2, it might be safer. But at phase 1 it is
        // already clear that the net must be created and so we might
        // introduce the net to avoid some deadlocks. Furthermore,
        // all information is present during phase 1, so there is no
        // problem either.
        //
        // The translation formalism for low-level reference nets
        // must take care of this issue.
        return LATE_CONFIRM;
    }

    // This will not take long.
    @Override
    public boolean isLong() {
        return false;
    }

    @Override
    public void execute(StepIdentifier stepIdentifier) {
        _netInstance.lateConfirmation(stepIdentifier);
    }

    @Override
    public void executeAfterException(StepIdentifier stepIdentifier, Throwable t) {}
}