package de.renew.net.serialisation;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

import de.renew.net.Net;

/**
 * Interface for reading {@link Net} instances from an {@link java.io.OutputStream}.
 */
public interface INetDeserializer {

    /**
     * Reads nets stored by {@link INetSerializer#saveAllKnownNets(ObjectOutput)}
     * and adds the new {@link Net} instances to the list
     * of known nets by name.
     * <p>
     * If the given {@code ObjectInput} is a
     * {@code de.renew.util.RenewObjectInputStream}, the
     * necessary steps to cover delayed serialization will
     * be made.
     * <p>
     * The {@code ObjectInputStream} will be read using
     * {@code de.renew.util.ClassSource} to provide
     * its ability of reloading all user defined classes.
     * <p>
     * Added Apr 18 2000  Michael Duvigneau
     * <p>
     * See also:
     *   {@link INetSerializer#saveAllKnownNets(ObjectOutput)}
     *   {@link de.renew.util.ClassSource}
     *   {@link de.renew.util.RenewObjectInputStream}
     *
     * @param objectInput source stream (see notes above)
     * @throws IOException if an error occurs while reading
     * @throws ClassNotFoundException if an object is read whose class cannot be found
     **/
    void loadNets(ObjectInput objectInput) throws IOException, ClassNotFoundException;
}
