package de.renew.net.serialisation;

import java.io.IOException;
import java.io.ObjectOutput;

import de.renew.net.Net;
import de.renew.simulator.api.SimulationLockExecutor;

/**
 * Interface for writing {@link Net} instances to an {@link java.io.OutputStream}.
 */
public interface INetSerializer {

    /**
     * Writes all currently known {@link Net} instances
     * to the given stream. The written information
     * describes the static part of all compiled nets.
     * <p>
     * If the given {@code ObjectOutput} is a
     * {@code de.renew.util.RenewObjectOutputStream}, its
     * feature of cutting down the recursion depth by delaying
     * the serialization of some fields will be used.
     * <p>
     * This method is mutually exclusive with all operations of the
     * {@link SimulationLockExecutor#lock()} facade
     * <p>
     * Added Apr 18 2000  Michael Duvigneau
     * <p>
     * See also: {@link de.renew.util.RenewObjectOutputStream}
     *
     * @param outputStream target stream (see note about RenewObjectOutputStream)
     * @throws IOException if an error occurs while writing
     **/
    void saveAllKnownNets(ObjectOutput outputStream) throws IOException;
}
