package de.renew.shadowcompiler;

import java.io.Serializable;


/**
 * An interface for classes that create {@code ShadowCompilers}.
 * <p>
 * A shadow compiler factory must be serializable in order
 * to be able to serialize the shadow net system.
 * </p>
 * @author Joern Schumacher
 **/
public interface ShadowCompilerFactory extends Serializable {
    /**
     * Creates a new {@code ShadowCompiler}.
     *
     * @return the newly created {@code ShadowCompiler}
     */
    ShadowCompiler createCompiler();
}