package de.renew.unify;

/**
 * Interface for copying {@link Unifiable} objects to protect them from
 * being lost due to backtracking during unification.
 * <p>
 * Copies are created recursively, preserving structure and inserting
 * {@link Unknown} objects where necessary.
 */
public interface ICopier {
    /**
     * This method copies an object of type {@link Unifiable}.
     * The object is copied recursively according to the following rules:
     * <ul>
     *     <li>If the object is complete, make a permanent copy.</li>
     *     <li>If the object is not complete, make a copy and
     *         insert new unknown objects appropriately.</li>
     * </ul>
     * This method should not be called from within during
     * a notification callback.
     * This method should not be called while there might be
     * a need to undo any operation on the created copies.
     *
     * @param obj the object to be copied
     * @return the copied object
     */
    Object copy(Object obj);
}
