package de.renew.unify;

/**
 * This is an interface for recording state changes that can be undone later.
 * It allows for recording changes, creating checkpoints, and restoring
 * states to a previous checkpoint.
 * Each change is encapsulated in a {@link StateRestorer}, which defines
 * how to revert the change.
 */
public interface IStateRecorder {
    /**
     * Records a state change that can later be undone.
     *
     * @param obj the {@code StateRestorer} that encapsulates how to undo a specific change
     */
    void record(StateRestorer obj);

    /**
     * Returns a checkpoint representing the current state of the recorder.
     * This checkpoint can be used later to restore to this exact point.
     *
     * @return the index of the checkpoint, can be used later to restore to this state
     */
    int checkpoint();

    /**
     * Restores the system to the state it was in at the given checkpoint.
     *
     * @param checkpoint the index of the checkpoint to restore
     */
    void restore(int checkpoint);

    /**
     * Restores all recorded changes by backtracking to the initial state.
     */
    void restore();
}
