package de.renew.unify;

/**
 * This interface can be used to add a listener to a {@link Variable} that will be
 * notified when the variable has become bound.
 */
public interface Notifiable {

    /**
     * This method is called to notify the target object
     * that it has become bound.
     *
     * @param recorder the state recorder
     * @throws Impossible if an impossible state occurs
     */
    void boundNotify(IStateRecorder recorder) throws Impossible;
}