package de.renew.unify;

/**
 * Interface for easy traversal of a {@link TupleIndex}.
 * Follows the visitor pattern.
 */
public interface TupleIndexVisitor {

    /**
     * Visit a component branch.
     *
     * @param branch the {@code ComponentBranch} to visit
     **/
    void visitBranch(ComponentBranch branch);

    /**
     * Visit an arity branch.
     * Return true, if traversal should proceed to deeper nodes.
     * This is the default.
     *
     * @param branch the {@code ArityBranch} to visit
     * @param remainder the remainder of the object to be traversed
     * @return {@code true}, if traversal should proceed to deeper nodes
     **/
    boolean visitIndex(ArityBranch branch, Object remainder);
}