package de.renew.net.event;

import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mock;
import org.mockito.MockedStatic;

import de.renew.engine.thread.SimulationThreadPool;
import de.renew.expression.VariableMapper;
import de.renew.net.PlaceInstance;
import de.renew.net.TransitionInstance;

import static org.assertj.core.api.Assertions.assertThat;
import static org.mockito.Mockito.mockStatic;

public class EventTest {
    @Mock
    private TransitionInstance _mockTransitionInstance;
    @Mock
    private PlaceInstance _mockPlaceInstance;
    @Mock
    private VariableMapper _mockMapper;

    private MockedStatic<SimulationThreadPool> _simulationThreadPoolMockedStatic;

    @BeforeEach
    public void setUp() {
        _simulationThreadPoolMockedStatic = mockStatic(SimulationThreadPool.class);
        _simulationThreadPoolMockedStatic.when(SimulationThreadPool::isSimulationThread)
            .thenReturn(true);
    }

    @AfterEach
    public void tearDown() {
        _simulationThreadPoolMockedStatic.close();
    }

    @Test
    public void testFiringEventConstruction() {
        //when
        FiringEvent event = new FiringEvent(_mockTransitionInstance, _mockMapper);

        //then
        assertThat(event.getSource()).isEqualTo(_mockTransitionInstance);
        assertThat(event.getVariableMapper()).isEqualTo(_mockMapper);
    }

    @Test
    public void testPlaceEventConstruction() {
        //when
        PlaceEvent event = new PlaceEvent(_mockPlaceInstance);

        //then
        assertThat(event.getPlaceInstance()).isEqualTo(_mockPlaceInstance);
        assertThat(event.getSource()).isEqualTo(_mockPlaceInstance);
    }

    @Test
    public void testTokenEventConstruction() {
        //given
        String token = "token";
        //when
        TokenEvent event = new TokenEvent(_mockPlaceInstance, token);

        //then
        assertThat(event.getPlaceInstance()).isEqualTo(_mockPlaceInstance);
        assertThat(event.getSource()).isEqualTo(_mockPlaceInstance);
        assertThat(event.getToken()).isEqualTo(token);
    }
}