package de.renew.net.inscription.transition;

import java.util.Collection;

import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

import de.renew.engine.searcher.Occurrence;
import de.renew.engine.searcher.Searcher;
import de.renew.expression.VariableMapper;
import de.renew.net.NetInstance;
import de.renew.unify.Impossible;

import static org.assertj.core.api.Assertions.assertThat;
import static org.mockito.Mockito.verify;

/**
 * Test class for {@link ExpressionInscription}.
 * Tests only the relevant (non-trivial) methods.
 */
class ExpressionInscriptionTest extends InscriptionTest {
    private ExpressionInscription _expressionInscription;

    /**
     * Setup method to initialize this test environment.
     */
    @BeforeEach
    void setUp() throws Impossible {
        super.setUp();
        _expressionInscription = new ExpressionInscription(_mockExpression);
    }

    /**
     * Test method for {@link ExpressionInscription#makeOccurrences(VariableMapper, NetInstance, Searcher)}.
     *
     * @throws Impossible if it is impossible to make the {@code Occurrence}s.
     */
    @Test
    void testMakeOccurrences() throws Impossible {
        //when
        Collection<Occurrence> occurrences =
            _expressionInscription.makeOccurrences(_mapper, _mockNetInstance, _searcher);

        //then
        verify(_mockExpression).startEvaluation(
            _mapper, _searcher.getStateRecorder(), _searcher.getCalculationChecker());
        assertThat(occurrences).isEmpty();
    }

    /**
     * Test method for {@link ExpressionInscription#toString()}.
     */
    @Test
    void testToString() {
        //when/then
        assertThat(_expressionInscription.toString())
            .isEqualTo("ExpressionInscription: " + _mockExpression);
    }
}