package de.renew.net.inscription.transition;

import java.util.Collection;

import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.MockedStatic;
import org.mockito.junit.jupiter.MockitoExtension;

import de.renew.engine.searcher.Occurrence;
import de.renew.engine.searcher.Searcher;
import de.renew.expression.VariableMapper;
import de.renew.net.NetInstance;
import de.renew.unify.Impossible;
import de.renew.unify.Unify;
import de.renew.util.Value;

import static org.assertj.core.api.Assertions.assertThat;
import static org.mockito.ArgumentMatchers.any;
import static org.mockito.ArgumentMatchers.eq;
import static org.mockito.Mockito.mockStatic;
import static org.mockito.Mockito.when;

/**
 * Test class for {@link GuardInscription}.
 * Tests only the relevant (non-trivial) methods.
 */
@ExtendWith(MockitoExtension.class)
class GuardInscriptionTest extends InscriptionTest {
    private GuardInscription _guardInscription;

    private Object _object;

    /**
     * Setup method to initialize this test environment.
     */
    @BeforeEach
    void setUp() throws Impossible {
        super.setUp();
        _guardInscription = new GuardInscription(_mockExpression);
        _object = new Object();

        when(_mockExpression.startEvaluation(any(), any(), any())).thenReturn(_object);
    }

    /**
     * Test method for {@link GuardInscription#makeOccurrences(VariableMapper, NetInstance, Searcher)}.
     *
     * @throws Impossible if it is impossible to make the {@code Occurrence}s.
     */
    @Test
    void testMakeOccurrences() throws Impossible {
        //given
        try (MockedStatic<Unify> mockedUnify = mockStatic(Unify.class)) {

            //when
            Collection<Occurrence> occurrences =
                _guardInscription.makeOccurrences(_mapper, _mockNetInstance, _searcher);

            //then
            mockedUnify.verify(() -> Unify.unify(eq(_object), eq(new Value(Boolean.TRUE)), any()));

            assertThat(occurrences).isEmpty();
        }
    }
}