package de.renew.net.inscription.transition;

import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mock;
import org.mockito.MockedStatic;

import de.renew.engine.thread.SimulationThreadPool;
import de.renew.net.NetInstance;
import de.renew.simulatorontology.simulation.StepIdentifier;
import de.renew.unify.Impossible;

import static org.mockito.Mockito.mock;
import static org.mockito.Mockito.mockStatic;
import static org.mockito.Mockito.verify;
import static org.mockito.Mockito.when;

/**
 * Test class for {@link LateConfirmer}.
 * Tests only the relevant (non-trivial) methods.
 */
class LateConfirmerTest {
    private MockedStatic<SimulationThreadPool> _mockedPool;

    @Mock
    private StepIdentifier _stepIdentifier;

    /**
     * Setup method to initialize this test environment.
     */
    @BeforeEach
    void setUp() throws Impossible {
        _mockedPool = mockStatic(SimulationThreadPool.class);
        when(SimulationThreadPool.isSimulationThread()).thenReturn(true);
    }

    /**
     * Setup method to close this test environment.
     */
    @AfterEach
    void tearDown() {
        _mockedPool.close();
    }

    /**
     * Test method for {@link LateConfirmer#execute(StepIdentifier)}.
     */
    @Test
    public void testExecute() {
        //given
        NetInstance mockNetInstance = mock(NetInstance.class);
        LateConfirmer lateConfirmer = new LateConfirmer(mockNetInstance);

        //when
        lateConfirmer.execute(_stepIdentifier);

        //then
        verify(mockNetInstance).lateConfirmation(_stepIdentifier);
    }
}