package de.renew.simulatorontology.serialisation;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;


/**
 * A {@code SerialisationListener} is used to notify an implementor about the serialisation and deserialisation of objects
 * of the generic type. Clients can then write own values to the given stream.
 *
 * For example, this is used to inform the simulator about the serialisation of shadow net systems, so that the
 * corresponding compiler can be added to the stream.
 */
public interface SerialisationListener<T> {

    /**
     * Called, when the given object gets serialized.
     *
     * @param object the object that is serialized
     * @param outputStream the stream the object is serialized with
     * @throws IOException thrown by the stream
     */
    void onWrite(T object, ObjectOutputStream outputStream) throws IOException;

    /**
     * Called, when the object gets deserialized.
     *
     * @param object the object that is deserialized
     * @param inputStream the stream the object is deserialized with
     * @throws IOException thrown by the stream
     * @throws ClassNotFoundException thrown by the stream
     */
    void onRead(T object, ObjectInputStream inputStream) throws IOException, ClassNotFoundException;
}
