package de.renew.simulatorontology.shadow;

import java.io.Serial;

/**
 * This class is responsible for creating instances of {@code ShadowDeclarationNode}
 * that are used in some formalisms to declare nets.
 * <p>
 * There can be at most one declaration node for any net (because some formalisms
 * don't allow declaration nodes) and there can only be one net for any
 * declaration node.
 */
public class ShadowDeclarationNode extends ShadowNetElement {
    /* Serialization support. */
    @Serial
    private static final long serialVersionUID = 687490760763472293L;
    /** The inscription of this {@code ShadowDeclarationNode}. */
    private final String _inscription;

    /**
     * Creates a new {@code ShadowDeclarationNode} associated with the {@code
     * ShadowNet} it permanently belongs to and the given inscription.
     *
     * @param shadowNet the shadow net this node permanently belongs to
     * @param inscription the inscription of the node
     */
    public ShadowDeclarationNode(ShadowNet shadowNet, String inscription) {
        super(shadowNet);
        _inscription = inscription;
    }

    /**
     * Getter for the inscription.
     *
     * @return the inscription
     */
    public String getInscription() {
        return _inscription;
    }
}