package de.renew.simulatorontology.simulation;

import java.util.Properties;


/**
 * Information container, comprises all parameters of the running
 * simulation.
 * <p>
 * SimulationEnvironment.java
 * Created: Thu Jun  5  2003
 *
 * @author Michael Duvigneau
 * @since Renew 2.0
 **/
public class SimulationEnvironment {
    private final Simulator _simulator;
    private final SimulatorExtension[] _extensions;
    private final Properties _properties;

    /**
     * Creates a new <code>SimulationEnvironment</code>
     * object that comprises all of the given information.
     * Any objects given as parameters are stored by
     * reference, so there is no cloning or other type of
     * information hiding.
     *
     * @param simulator  the simulation engine used in this simulation.
     * @param extensions array of active extensions in this simulation.
     * @param properties the properties used to set up this simulation.
     **/
    public SimulationEnvironment(
        Simulator simulator, SimulatorExtension[] extensions, Properties properties)
    {
        _simulator = simulator;
        _extensions = extensions;
        _properties = properties;
    }

    /**
     * Gets the simulation engine of this environment.
     *
     * @return the simulation engine of this environment.
     **/
    public Simulator getSimulator() {
        return _simulator;
    }

    /**
     * Gets the active extensions in this simulation
     * environment.
     *
     * @return an array of active extensions in this simulation.
     **/
    public SimulatorExtension[] getExtensions() {
        return _extensions;
    }

    /**
     * Gets the properties used in this simulation
     * environment.
     *
     * @return the properties used in this simulation
     **/
    public Properties getProperties() {
        return _properties;
    }
}