package de.renew.simulatorontology.shadow;

import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

import static org.assertj.core.api.Assertions.assertThat;
import static org.mockito.Mockito.any;
import static org.mockito.Mockito.doNothing;
import static org.mockito.Mockito.mock;
import static org.mockito.Mockito.when;


/**
 * Test class for {@link ShadowInscription}.
 * Tests only the relevant (non-trivial) methods.
 */
class ShadowInscriptionTest {
    private static final String NAME_MOCK = "testInscription";

    private ShadowInscribable _shadowInscribableMock;
    private ShadowInscription _shadowInscription;

    /**
     * Setup method to initialize this test environment.
     */
    @BeforeEach
    public void setUp() {
        _shadowInscribableMock = mock(ShadowInscribable.class);
        ShadowNet shadowNetMock = mock(ShadowNet.class);
        when(_shadowInscribableMock.getNet()).thenReturn(shadowNetMock);
        doNothing().when(_shadowInscribableMock).add(any());

        _shadowInscription = new ShadowInscription(_shadowInscribableMock, NAME_MOCK);
    }

    /**
     * Test method for the constructor of {@link ShadowInscription}.
     */
    @Test
    public void testShadowInscription() {
        // Then
        assertThat(_shadowInscription).isNotNull();
        assertThat(_shadowInscription.getInscribable()).isEqualTo(_shadowInscribableMock);
        assertThat(_shadowInscription.getInscription()).isEqualTo(NAME_MOCK);
    }

    /**
     * Test method for {@link ShadowInscription#toString()}.
     */
    @Test
    public void testToString() {
        // When
        String inscription = _shadowInscription.toString();
        // Then
        assertThat(inscription)
            .isEqualTo("ShadowInscription \"" + NAME_MOCK + "\" an " + _shadowInscribableMock);
    }
}