package de.renew.splashscreen.api;

import java.beans.PropertyChangeEvent;
import java.net.URL;

import de.renew.plugin.PluginAdapter;
import de.renew.plugin.PluginException;
import de.renew.plugin.PluginProperties;
import de.renew.plugin.load.ISplashscreenPlugin;

/**
 * The main class of the {@code SplashscreenPlugin}.
 *
 * @author Dominic Dibbern
 * @date Jan 23, 2012
 */
public class SplashscreenPlugin extends PluginAdapter implements ISplashscreenPlugin {

    /**
     * Construct a new instance of the {@code SplashscreenPlugin}.
     * This constructor is called via reflection from
     * {@link de.renew.plugin.load.AbstractPluginLoader}
     *
     * @param propertyURL URL to the properties file
     * @throws PluginException if the instantiation failed.
     */
    public SplashscreenPlugin(URL propertyURL) throws PluginException {
        super(propertyURL);
        showSplashscreenIfEnabled();
    }

    /**
     * Construct a new instance of the {@code SplashscreenPlugin}.
     * This constructor is called via reflection from
     * {@link de.renew.plugin.load.AbstractPluginLoader}
     *
     * @param props properties for this plugin
     */
    public SplashscreenPlugin(PluginProperties props) {
        super(props);
        showSplashscreenIfEnabled();
    }

    private void showSplashscreenIfEnabled() {
        Object[] args = { getProperties() };
        try {
            ProcessInterface.executeProcess("SHOW_SPLASHSCREEN", args, this);
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean cleanup() {
        try {
            ProcessInterface.executeProcess("CLEANUP", null, this);
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
        return super.cleanup();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        Object[] args = { evt };
        try {
            ProcessInterface.executeProcess("PROPERTY_CHANGE", args, this);
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void closeSplashScreen() {
        try {
            ProcessInterface.executeProcess("CLOSE_SPLASHSCREEN", null, this);
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}
