package de.renew.splashscreen.proc;

import org.apache.log4j.Logger;

import de.renew.plugin.PluginProperties;
import de.renew.plugin.load.ISplashscreenPlugin;
import de.renew.splashscreen.implinterface.ImplInterface;

/**
 *  This class describes the show splashscreen process.
 *  If the splashscreen is enabled and an implementation exists, a splashscreen is displayed.
 *
 * @author Niklas Levens
 * @author Tom Dasenbrook
 * @date Dec 2, 2025
 */
public class ShowSplashscreen implements SequentialProcess {

    private final String PROCESS_KEY = "SHOW_SPLASHSCREEN";

    private static final String KEY_SPLASHSCREEN_ENABLED = "de.renew.splashscreen.enabled";

    private static final Logger LOGGER = Logger.getLogger(ShowSplashscreen.class.getName());

    /**
     * Creates an instance of the ShowSplashscreen class.
     */
    public ShowSplashscreen() {}

    @Override
    public Object execute(Object[] args, ISplashscreenPlugin trigger) {
        ImplInterface _implInterface = new ImplInterface();
        PluginProperties properties = (PluginProperties) args[0];
        if (properties.getBoolProperty(KEY_SPLASHSCREEN_ENABLED)) {
            if (_implInterface.checkSplashScreenNotNull()) {
                ImplInterface.showSplashScreen();
                _implInterface.setSplashscreenPlugin(trigger);
            }
        } else {
            LOGGER.debug("Splash screen disabled by user choice.");
        }
        return null;
    }

    @Override
    public String getKey() {
        return PROCESS_KEY;
    }

}
