<!-- Adapted from: https://www.writethedocs.org/guide/writing/beginners-guide-to-docs/ -->

# Tablet

## User Guide

_Tablet_ adds a new palette to the tool bar. The first tool allows the user to draw freely in a net. The second tool adds the option to draw places and transitions alternately easier. 

### Features

- Draw freely in a given net
- Draw places and transitions alternately 

### Example Usage

1. Display the new palette via Tools -> Tablet -> show / hide tablet tools
2. Open any net in the graphical editor.
3. Select the "tablet scribble" icon from the new Tool section to draw a circle around a net.
4. Select the "toggle p / t" icon to efficiently draw a simple net of 2 places and transitions.

### Provided Commands

<!-- Use the classes implementing CLCommand. The 'help' output of the command can be a useful description -->

None.

### Installation

Install _Tablet_ by putting the JAR file inside the `dist/plugins` directory.

It will be automatically loaded at startup of Renew - see below for more configuration options.

### Dependencies

This plugin depends on the following plugins and external libraries:

<!-- must match the `module-info.java` -->

- `Gui`: Add a new set of drawing tools
- `log4j`: Logging Framework

### Configuration

During the initialization of MiniMap, no properties are read that could be configured.


## Developer Guide

### Core Classes

- `TabletPlugin`: Extends the `PluginAdapter` abstract class to manage the startup and shutdown.
- `PTToggleCreationTool`: Implements the p / t draw tool.
- `ScribbleTool`: Implements the free draw tool.

### How to Extend

_Tablet_ does not currently support extensions.
