package de.renew.tablet;

import CH.ifa.draw.util.Palette;
import de.renew.draw.ui.ontology.DrawingEditor;
import de.renew.draw.ui.ontology.Tool;
import de.renew.gui.GuiPlugin;
import de.renew.gui.PaletteHolder;
import de.renew.tablet.tools.PTToggleCreationTool;
import de.renew.tablet.tools.ScribbleTool;


/**
 * A class to create, add and remove the tablet palette from the tools panel.
 *

 * @author Lawrence Cabac
 * @version 0.2b,  October 2003
 *
 */
public class PaletteCreator {
    private static final org.apache.log4j.Logger LOGGER =
        org.apache.log4j.Logger.getLogger(PaletteCreator.class);



    //private static final String IMAGES = "images/";


    /**
     * The palette that holds the tool buttons of this PaletteCreator.
     */
    private Palette _palette;

    /**
     * The signifier of this PaletteCreator.
     */
    private String _label;

    /**
     * Constructor for PaletteCreator. It has to know the  CPN application.
     * The tools directory is determined by the "user.toolsdir" java commandline argument.
     *
     * @param name the CPNApplication to which the palette should be added
     */
    public PaletteCreator(String name) {
        create(name);
    }

    /**
     * Method createTools.
     *
     * @param paletteName - the tools directory name.
     */
    void create(String paletteName) {
        GuiPlugin starter = GuiPlugin.getCurrent();
        PaletteHolder paletteHolder = starter.getPaletteHolder();

        //        toolPanel = cpnapp.getToolsPanel();
        //        menuFrame = cpnapp.menuFrame();
        String images = "/de/renew/tablet/images/";


        //this.getClass()
        //                            .getResource("").toString();
        //                            "/de/renew/diagram/images/"
        //                            .toString().substring(5);
        // create tools for Net-Components
        // logger.debug(IMAGES);
        Tool tool;

        _palette = new Palette(paletteName);
        DrawingEditor editor = starter.getDrawingEditor();


        tool = new ScribbleTool(editor);
        _palette.add(paletteHolder.createToolButton(images + "scribble", "tablet scribble", tool));
        tool = new PTToggleCreationTool(editor);
        _palette.add(paletteHolder.createToolButton(images + "toggle", "toggle p / t", tool));

        paletteHolder.addPalette(_palette);


        // cpnapp.menuFrame().pack();
        //  end of elements for diagram drawing figures                              
        // start of decoration firgures
        // using the 
    }

    // end of create()


    /**
     * Method remove.
    * Removes the PaletteCreator from the toolsPanel.
     */
    public void remove() {
        GuiPlugin starter = GuiPlugin.getCurrent();
        if (starter == null) {
            return;
        }
        starter.getPaletteHolder().removePalette(_palette);
    }

    /**
     * Returns the label
     *
     * @return the label
     */
    public String getLabel() {
        return _label;
    }

    /**
    * Returns the label
    *
    * @return the label
    */
    @Override
    public String toString() {
        return getLabel();
    }
}