package de.renew.util;

/**
 * Tiny maths utility class implementing some custom math functions.
 */
public class Dist {
    /**
     * For the submitted value, multiply its negative value with the natural logarithm of a random number between inclusive 1.0
     * and exclusive 0.0. Given this is a double value which may be close to zero, a very large negative value may be produced
     * and multiplied with the submitted value. 
     *
     * @param avg a double value
     * @return a quasi-randomized value.
     */
    public static double negexp(double avg) {
        return -avg * Math.log(1 - Math.random());
    }
}