package de.renew.util;

import java.util.Objects;

/**
 * This class implements custom implementations of the {@link Object#equals(Object)} and {@link Object#hashCode()} methods
 * that can deal with null-pointer objects in an improved fashion.
 *
 * @author Olaf Kummer
 * @author Frank Wienberg
  */
public class Null {
    /**
     * Check two objects for equality in the sense of their type's {@link Object#equals(Object)} method, without
     * failing if either or both objects are of null type.
     * @param o1 the object on which to compare if o2 is equal. May be null type.
     * @param o2 the object which will be checked for equality with 01. May be null type.
     * @return False if one Object is null type. True if both objects are null type. Else like the types {@link Object#equals(Object)}  implementation.
     */
    public static boolean nullAwareEquals(Object o1, Object o2) {
        return Objects.equals(o1, o2);
    }

    /**
     * Check if the object has a hash code, without failing if the object is of null type.
     * @param object the object for which to retrieve its hash code
     * @return int 0 if the object is of null type. The hash code as returned by {@link Object#hashCode()} implementation of the type otherwise.
     */
    public static int nullAwareHashCode(Object object) {
        return object == null ? 0 : object.hashCode();
    }
}