package de.renew.util;

import java.util.Vector;


/**
 * The <code>ThreadPool</code> runs runnables in threads that
 * are recycled after the runnable completes.
 *
 * @author Olaf Kummer
 */
public class ThreadPool {
    private final static int MAXPOOLSIZE = 32;
    private static final Vector<PoolThread> POOL = new Vector<>(MAXPOOLSIZE);

    static void put(PoolThread thread) {
        synchronized (POOL) {
            if (POOL.size() < MAXPOOLSIZE) {
                POOL.addElement(thread);
            } else {
                thread.executeOrDiscard(null);
            }
        }
    }

    static PoolThread get() {
        synchronized (POOL) {
            int size = POOL.size();
            if (size == 0) {
                return new PoolThread();
            } else {
                PoolThread thread = POOL.elementAt(size - 1);
                POOL.removeElementAt(size - 1);
                return thread;
            }
        }
    }
}